*! version 4.0
* 30 May 2020
* NIDS-CRAM 
* Merging NIDS-CRAM and derived dataset to create a Cross-sectional dataset.

* Will run on all waves

*===========================================================================================================================================
* GLOBALS FOR DATA FILES AND VERSION SUFFIXES

global DataIN "C:\Users\Admin\Desktop\Data\Wave 5"
global DataOUT "C:\Users\Admin\Desktop\Data\Wave 5"

global VersionIN "Wave5_Anon_V1.0.0"								// Wave and version of the data being used.
global VersionOUT "W5_merged"

version 15.1													// version of Stata being used, this is needed for the rename command.

*===========================================================================================================================================

* OPENING THE NIDS-CRAM DATA

use "$DataIN\NIDS-CRAM_$VersionIN.dta", clear					// opening the dataset
	
merge 1:1 pid using "$DataIN\derived_NIDS-CRAM_$VersionIN.dta"	// merging in the derived dataset

drop _m

save "$DataOUT\Crossection_$VersionOUT.dta", replace			// saving out the resulting dataset, the defined path, as per globals

*-------------------------------------------------------------------------------------------------------------------------------------------

*THE END
